using System;
using System.Data;
using System.Data.SqlClient;
using System.Reflection;
using TABLE = gov.va.med.vbecs.Common.VbecsTables.ComponentClass;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;
using gov.va.med.vbecs.ExceptionManagement;
using MethodBase = System.Reflection.MethodBase;

namespace gov.va.med.vbecs.DAL
{
		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/19/2002</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>
		/// Static class implementing a data persistence logic for a blood component class.
		/// Retrieves from/saves to database BOL.BloodComponentClass class data. 
		///</summary>

		#endregion

	public class BloodComponentClass
	{

		#region Methods

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/22/2002</CreationDate>
		///<TestCases>
		///<Case type="0" testid ="962"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>The DataTable containing component class types</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="819"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets a datatable of all blood component class values from database -  BR_10.01
		/// </summary>
		/// <returns>Datatable containing blood component class values list</returns>
		public static DataTable GetComponentClassValues()
		{
			DataSet dtRows = Common.StoredProcedure.GetData(STOREDPROC.GetComponentClassTypeLookupList.StoredProcName);
			return dtRows.Tables[0];
		}

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/25/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2955"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable of ComponentRequirements</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2956"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Returns a data table of component requirements
		/// </summary>
		/// <returns></returns>
		public static DataTable GetComponentRequirements()
		{
			DataSet dtRows = Common.StoredProcedure.GetData(STOREDPROC.GetComponentRequirements.StoredProcName);
			return dtRows.Tables[0];
		}

		///<Developers>
		///	<Developer>Mike Smith</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/19/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1049"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable containing component classes</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="1882"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///<summary>
		/// Retrieves names and other information for all component classes available 
		/// within specified division. In other words - retrieves list of component classes
		/// for given division.
		///</summary>
		public static DataTable GetComponentClasses()
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetComponentClass.divisioncode, System.Data.SqlDbType.VarChar)
			};

			prms[0].Value = Common.LogonUser.LogonUserDivisionCode;
		
			DataSet ds = Common.StoredProcedure.GetData(STOREDPROC.GetComponentClass.StoredProcName, prms);
							
			DataTable dt = ds.Tables[0];
			return dt;
		}

		#endregion
	}
}







